/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.ItemDescriptor;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ProgressBean
implements DataBean {
    private static final String HELPSET_KEY = "HELPSET:";
    private static final String HELPID_KEY = "HELPID:";
    private static final String TOPIC_PREFIX = "/help/topic/";
    private static final String TOPIC_SUFFIX = ".html";
    private static final String DEFAULT_HELPSET = "base";
    private static final String DEFAULT_TARGET_HELPID = "com.ibm.hwmca.fw.task.res.ProgressRes.TargetProgressPanel";
    private static final String DEFAULT_NONTARGET_HELPID = "com.ibm.hwmca.fw.task.res.ProgressRes.NonTargetedProgressPanel";
    private ProgressStartEvent startEvent = null;
    private long startTime;
    private boolean ended = false;
    private boolean canceled = false;
    private String m_sDurationTimeOutput;
    private String m_sElapsedTimeOutput;
    private String m_sProgressMessageOutput;
    private String[] m_sObjectNamePCol;
    private ItemDescriptor[] m_idObjectNamePCol;
    private String[] m_sObjectStatusCol;
    private ItemDescriptor[] m_idObjectStatusCol;
    private ActionDescriptor[] m_adContextMenu;

    void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    void setEnded(boolean ended) {
        this.ended = ended;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public void setStartEvent(ProgressStartEvent startEvent) {
        this.startEvent = startEvent;
    }

    public ProgressStartEvent getStartEvent() {
        return this.startEvent;
    }

    public long getDuration() {
        ProgressData[] data = this.startEvent.getProgressData();
        long durationTime = 0L;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getDurationTime() <= durationTime) continue;
            durationTime = data[i].getDurationTime();
        }
        return durationTime;
    }

    public void setDuration() {
        SimpleDateFormat sdf;
        ProgressData[] data = this.startEvent.getProgressData();
        long durationTime = this.getDuration();
        Calendar cal = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            sdf = new SimpleDateFormat("HH:mm:ss", userContext.getLocale());
            sdf.setTimeZone(userContext.getTimeZone());
            cal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        }
        catch (NullContextException e) {
            sdf = new SimpleDateFormat("HH:mm:ss");
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.add(14, (int)durationTime * 1000);
        this.m_sDurationTimeOutput = "" + sdf.format(cal.getTime());
    }

    public void setElapsed() {
        if (!this.ended) {
            SimpleDateFormat sdf;
            long curTime = System.currentTimeMillis();
            Calendar cal = null;
            try {
                ClientUserContext userContext = ClientUserContext.getUserContext();
                sdf = new SimpleDateFormat("HH:mm:ss", userContext.getLocale());
                sdf.setTimeZone(userContext.getTimeZone());
                cal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
            }
            catch (NullContextException e) {
                sdf = new SimpleDateFormat("HH:mm:ss");
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.add(14, (int)(curTime - this.startTime));
            this.m_sElapsedTimeOutput = "" + sdf.format(cal.getTime());
        }
    }

    public String getDurationTimeOutput() {
        return this.m_sDurationTimeOutput;
    }

    public String getElapsedTimeOutput() {
        this.setElapsed();
        return this.m_sElapsedTimeOutput;
    }

    public String getProgressHelpTopic() {
        String helpset = null;
        String name = null;
        try {
            int pos2;
            int pos1;
            String helpinfo = this.startEvent.getHelpInfo();
            if (helpinfo != null && (pos1 = helpinfo.indexOf(HELPSET_KEY)) != -1 && (pos2 = helpinfo.indexOf("help.hs;", pos1 += HELPSET_KEY.length())) != -1) {
                String set = helpinfo.substring(pos1, pos2);
                pos1 = helpinfo.indexOf(HELPID_KEY);
                if (pos1 != -1) {
                    String id = helpinfo.substring(pos1 += HELPID_KEY.length());
                    helpset = set;
                    name = id;
                }
            }
        }
        catch (Exception e) {
            name = null;
            helpset = null;
        }
        if (helpset == null || name == null) {
            helpset = DEFAULT_HELPSET;
            ProgressData[] data = this.startEvent.getProgressData();
            name = data.length == 1 && data[0].getObjectId() == null ? DEFAULT_NONTARGET_HELPID : DEFAULT_TARGET_HELPID;
        }
        return TOPIC_PREFIX + helpset + "/" + name.replace('.', '/') + TOPIC_SUFFIX;
    }

    public String getProgressMessageOutput() {
        return this.m_sProgressMessageOutput;
    }

    public void setProgressMessageOutput(String s) {
        this.m_sProgressMessageOutput = s;
    }

    public ItemDescriptor[] getObjectNamePColList() {
        return this.m_idObjectNamePCol;
    }

    public void setObjectNamePColList(ItemDescriptor[] items) {
        this.m_idObjectNamePCol = items;
    }

    public String[] getObjectNamePColSelection() {
        return this.m_sObjectNamePCol;
    }

    public void setObjectNamePColSelection(String[] select) {
        this.m_sObjectNamePCol = select;
    }

    public ItemDescriptor[] getObjectStatusColList() {
        return this.m_idObjectStatusCol;
    }

    public void setObjectStatusColList(ItemDescriptor[] items) {
        this.m_idObjectStatusCol = items;
    }

    public String[] getObjectStatusColSelection() {
        return this.m_sObjectStatusCol;
    }

    public void setObjectStatusColSelection(String[] select) {
        this.m_sObjectStatusCol = select;
    }

    public ActionDescriptor[] getContextMenuList() {
        return this.m_adContextMenu;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() {
    }

    public void save() {
    }

    public void load() {
        ProgressData[] data = this.startEvent.getProgressData();
        this.setDuration();
        this.startTime = System.currentTimeMillis();
        this.setElapsed();
        if (data.length == 1 && data[0].getObjectId() == null) {
            this.m_sObjectNamePCol = new String[0];
            this.m_idObjectNamePCol = new ItemDescriptor[0];
            this.m_sObjectStatusCol = new String[0];
            this.m_idObjectStatusCol = new ItemDescriptor[0];
            this.m_sProgressMessageOutput = data[0].getText().toString();
        } else {
            this.m_sProgressMessageOutput = "";
            this.m_sObjectNamePCol = new String[1];
            this.m_idObjectNamePCol = new ItemDescriptor[data.length];
            this.m_sObjectStatusCol = new String[1];
            this.m_idObjectStatusCol = new ItemDescriptor[data.length];
            for (int i = 0; i < data.length; ++i) {
                this.m_idObjectNamePCol[i] = new ItemDescriptor("Object_" + String.valueOf(i), data[i].getName().toString().replace('\n', ' '));
                this.m_idObjectStatusCol[i] = new ItemDescriptor("Status_" + String.valueOf(i), data[i].getText().toString());
                if (i != 0) continue;
                this.m_sObjectNamePCol[i] = this.m_idObjectNamePCol[i].getTitle();
                this.m_sObjectStatusCol[i] = this.m_idObjectStatusCol[i].getTitle();
            }
        }
        this.m_adContextMenu = new ActionDescriptor[0];
    }

    public String getElapsedHours() {
        String[] values = this.getElapsedTimeOutput().split(":");
        return values[0];
    }

    public String getElapsedMinutes() {
        String[] values = this.getElapsedTimeOutput().split(":");
        return values[1];
    }

    public String getElapsedSeconds() {
        String[] values = this.getElapsedTimeOutput().split(":");
        return values[2];
    }
}

